/**
 * External dependencies
 */
import styled from '@emotion/styled';

/**
 * SolidWP dependencies
 */
import { Text } from '@ithemes/ui';

export const StyledGetPro = styled.a`
	display: flex;
	flex-direction: row;
	align-items: center;
	gap: 1.5rem;
	padding: 0.25rem 0.75rem;
	border: 1px solid ${ ( { theme } ) => theme.colors.border.muted };
	border-radius: 0.25rem;
	text-decoration: none;
	margin-right: auto;
	
	& > svg {
		flex: 1 0 auto;
	}
`;

export const StyledGetProText = styled( Text )`
	& > span {
		display: inline-block;
	}
	
	& span {
		text-transform: uppercase;
	}
`;
