<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package darkoob
 */

?>

<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
	

<div class="content-left col-md-8 col-xs-12">
	<?php darkoob_post_thumbnail(); ?>

	<header class="entry-header">
		<?php
		if ( is_singular() ) :
			the_title( '<h1 class="entry-title">', '</h1>' );
		else :
			the_title( '<h2 class="entry-title"><a href="' . esc_url( get_permalink() ) . '" rel="bookmark">', '</a></h2>' );
		endif;
		if ( 'post' === get_post_type() ) :
			?>
			<div class="entry-meta">
				<?
				?><span class="date"><?php the_time('Y,m,d'); ?></span><?php
				//darkoob_posted_on();
				//darkoob_posted_by();
				?>
			</div><!-- .entry-meta -->
		<?php endif; ?>
	</header><!-- .entry-header -->

	<div class="entry-content">
		<?php
		the_content(
			sprintf(
				wp_kses(
					/* translators: %s: Name of current post. Only visible to screen readers */
					__( 'Continue reading<span class="screen-reader-text"> "%s"</span>', 'darkoob' ),
					array(
						'span' => array(
							'class' => array(),
						),
					)
				),
				wp_kses_post( get_the_title() )
			)
		);

		wp_link_pages(
			array(
				'before' => '<div class="page-links">' . esc_html__( 'Pages:', 'darkoob' ),
				'after'  => '</div>',
			)
		);
		?>
	</div><!-- .entry-content -->

	<!-- <footer class="entry-footer">
		<?php darkoob_entry_footer(); ?>
	</footer> -->
	<!-- .entry-footer -->
</div>

<div class="blog-content-right col-md-4 col-xs-12">
   <?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('blog-content-right') ) : ?><?php endif; ?>   
</div>

</article><!-- #post-<?php the_ID(); ?> -->
