<?php
/**
 * darkoob functions and definitions
 *
 * @link https://developer.wordpress.org/themes/basics/theme-functions/
 *
 * @package darkoob
 */

if ( ! defined( '_S_VERSION' ) ) {
	// Replace the version number of the theme on each release.
	define( '_S_VERSION', '1.0.0' );
}

if ( ! function_exists( 'darkoob_setup' ) ) :
	/**
	 * Sets up theme defaults and registers support for various WordPress features.
	 *
	 * Note that this function is hooked into the after_setup_theme hook, which
	 * runs before the init hook. The init hook is too late for some features, such
	 * as indicating support for post thumbnails.
	 */
	function darkoob_setup() {
		/*
		 * Make theme available for translation.
		 * Translations can be filed in the /languages/ directory.
		 * If you're building a theme based on darkoob, use a find and replace
		 * to change 'darkoob' to the name of your theme in all the template files.
		 */
		load_theme_textdomain( 'darkoob', get_template_directory() . '/languages' );

		// Add default posts and comments RSS feed links to head.
		add_theme_support( 'automatic-feed-links' );

		/*
		 * Let WordPress manage the document title.
		 * By adding theme support, we declare that this theme does not use a
		 * hard-coded <title> tag in the document head, and expect WordPress to
		 * provide it for us.
		 */
		add_theme_support( 'title-tag' );

		/*
		 * Enable support for Post Thumbnails on posts and pages.
		 *
		 * @link https://developer.wordpress.org/themes/functionality/featured-images-post-thumbnails/
		 */
		add_theme_support( 'post-thumbnails' );

		// This theme uses wp_nav_menu() in one location.
		register_nav_menus(
			array(
				'menu-1' => esc_html__( 'Primary', 'darkoob' ),
			)
		);

		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'search-form',
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
			)
		);

		// Set up the WordPress core custom background feature.
		add_theme_support(
			'custom-background',
			apply_filters(
				'darkoob_custom_background_args',
				array(
					'default-color' => 'ffffff',
					'default-image' => '',
				)
			)
		);

		// Add theme support for selective refresh for widgets.
		add_theme_support( 'customize-selective-refresh-widgets' );

		/**
		 * Add support for core custom logo.
		 *
		 * @link https://codex.wordpress.org/Theme_Logo
		 */
		add_theme_support(
			'custom-logo',
			array(
				'height'      => 250,
				'width'       => 250,
				'flex-width'  => true,
				'flex-height' => true,
			)
		);
	}
endif;
add_action( 'after_setup_theme', 'darkoob_setup' );

/**
 * Set the content width in pixels, based on the theme's design and stylesheet.
 *
 * Priority 0 to make it available to lower priority callbacks.
 *
 * @global int $content_width
 */
function darkoob_content_width() {
	$GLOBALS['content_width'] = apply_filters( 'darkoob_content_width', 640 );
}
add_action( 'after_setup_theme', 'darkoob_content_width', 0 );

/**
 * Register widget area.
 *
 * @link https://developer.wordpress.org/themes/functionality/sidebars/#registering-a-sidebar
 */
function darkoob_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Sidebar', 'darkoob' ),
			'id'            => 'sidebar-1',
			'description'   => esc_html__( 'Add widgets here.', 'darkoob' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'tell', 'darkoob' ),
			'id'            => 'tell',
			'description'   => esc_html__( 'Add widgets here.', 'darkoob' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
			array(
				'name'          => esc_html__( 'social-menu', 'darkoob' ),
				'id'            => 'social-menu',
				'description'   => esc_html__( 'Add widgets here.', 'darkoob' ),
				'before_widget' => '<section id="%1$s" class="widget %2$s">',
				'after_widget'  => '</section>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			)
		);

	register_sidebar(
		array(
			'name'          => esc_html__( 'main-menu', 'darkoob' ),
			'id'            => 'main-menu',
			'description'   => esc_html__( 'Add widgets here.', 'darkoob' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
		array(
			'name'          => esc_html__( 'slider', 'darkoob' ),
			'id'            => 'slider',
			'description'   => esc_html__( 'Add widgets here.', 'darkoob' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

    register_sidebar(
		array(
			'name'          => esc_html__( 'content1', 'darkoob' ),
			'id'            => 'content1',
			'description'   => esc_html__( 'Add widgets here.', 'darkoob' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

    register_sidebar(
		array(
			'name'          => esc_html__( 'content2', 'darkoob' ),
			'id'            => 'content2',
			'description'   => esc_html__( 'Add widgets here.', 'darkoob' ),
			'before_widget' => '<section id="%1$s" class="widget %2$s">',
			'after_widget'  => '</section>',
			'before_title'  => '<h2 class="widget-title">',
			'after_title'   => '</h2>',
		)
	);

	register_sidebar(
			array(
				'name'          => esc_html__( 'content3', 'darkoob' ),
				'id'            => 'content3',
				'description'   => esc_html__( 'Add widgets here.', 'darkoob' ),
				'before_widget' => '<section id="%1$s" class="widget %2$s">',
				'after_widget'  => '</section>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			)
		);

		register_sidebar(
				array(
					'name'          => esc_html__( 'content4', 'darkoob' ),
					'id'            => 'content4',
					'description'   => esc_html__( 'Add widgets here.', 'darkoob' ),
					'before_widget' => '<section id="%1$s" class="widget %2$s">',
					'after_widget'  => '</section>',
					'before_title'  => '<h2 class="widget-title">',
					'after_title'   => '</h2>',
				)
			);

           
		register_sidebar(
				array(
					'name'          => esc_html__( 'content5', 'darkoob' ),
					'id'            => 'content5',
					'description'   => esc_html__( 'Add widgets here.', 'darkoob' ),
					'before_widget' => '<section id="%1$s" class="widget %2$s">',
					'after_widget'  => '</section>',
					'before_title'  => '<h2 class="widget-title">',
					'after_title'   => '</h2>',
				)
			);

			register_sidebar(
					array(
						'name'          => esc_html__( 'content6', 'darkoob' ),
						'id'            => 'content6',
						'description'   => esc_html__( 'Add widgets here.', 'darkoob' ),
						'before_widget' => '<section id="%1$s" class="widget %2$s">',
						'after_widget'  => '</section>',
						'before_title'  => '<h2 class="widget-title">',
						'after_title'   => '</h2>',
					)
				);

			register_sidebar(
			array(
				'name'          => esc_html__( 'content7', 'darkoob' ),
				'id'            => 'content7',
				'description'   => esc_html__( 'Add widgets here.', 'darkoob' ),
				'before_widget' => '<section id="%1$s" class="widget %2$s">',
				'after_widget'  => '</section>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			)
		);

			register_sidebar(
			array(
				'name'          => esc_html__( 'content8', 'darkoob' ),
				'id'            => 'content8',
				'description'   => esc_html__( 'Add widgets here.', 'darkoob' ),
				'before_widget' => '<section id="%1$s" class="widget %2$s">',
				'after_widget'  => '</section>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			)
		);

			register_sidebar(
			array(
				'name'          => esc_html__( 'content9', 'darkoob' ),
				'id'            => 'content9',
				'description'   => esc_html__( 'Add widgets here.', 'darkoob' ),
				'before_widget' => '<section id="%1$s" class="widget %2$s">',
				'after_widget'  => '</section>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			)
		);

			register_sidebar(
			array(
				'name'          => esc_html__( 'content10', 'darkoob' ),
				'id'            => 'content10',
				'description'   => esc_html__( 'Add widgets here.', 'darkoob' ),
				'before_widget' => '<section id="%1$s" class="widget %2$s">',
				'after_widget'  => '</section>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			)
		);

		register_sidebar(
			array(
				'name'          => esc_html__( 'foot-box1', 'darkoob' ),
				'id'            => 'foot-box1',
				'description'   => esc_html__( 'Add widgets here.', 'darkoob' ),
				'before_widget' => '<section id="%1$s" class="widget %2$s">',
				'after_widget'  => '</section>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			)
		);

		register_sidebar(
			array(
				'name'          => esc_html__( 'foot-box2', 'darkoob' ),
				'id'            => 'foot-box2',
				'description'   => esc_html__( 'Add widgets here.', 'darkoob' ),
				'before_widget' => '<section id="%1$s" class="widget %2$s">',
				'after_widget'  => '</section>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			)
		);

			register_sidebar(
			array(
				'name'          => esc_html__( 'foot-box3', 'darkoob' ),
				'id'            => 'foot-box3',
				'description'   => esc_html__( 'Add widgets here.', 'darkoob' ),
				'before_widget' => '<section id="%1$s" class="widget %2$s">',
				'after_widget'  => '</section>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			)
		);

   register_sidebar(
			array(
				'name'          => esc_html__( 'blog-content-right', 'darkoob' ),
				'id'            => 'blog-content-right',
				'description'   => esc_html__( 'Add widgets here.', 'darkoob' ),
				'before_widget' => '<section id="%1$s" class="widget %2$s">',
				'after_widget'  => '</section>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			)
		);

   register_sidebar(
			array(
				'name'          => esc_html__( 'lan', 'darkoob' ),
				'id'            => 'lan',
				'description'   => esc_html__( 'Add widgets here.', 'darkoob' ),
				'before_widget' => '<section id="%1$s" class="widget %2$s">',
				'after_widget'  => '</section>',
				'before_title'  => '<h2 class="widget-title">',
				'after_title'   => '</h2>',
			)
		);

	

}
add_action( 'widgets_init', 'darkoob_widgets_init' );

/**
 * Enqueue scripts and styles.
 */
function darkoob_scripts() {
	wp_enqueue_style( 'darkoob-style', get_stylesheet_uri(), array(), _S_VERSION );
	wp_style_add_data( 'darkoob-style', 'rtl', 'replace' );

	wp_enqueue_script( 'darkoob-navigation', get_template_directory_uri() . '/js/navigation.js', array(), _S_VERSION, true );

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}
add_action( 'wp_enqueue_scripts', 'darkoob_scripts' );

/**
 * Implement the Custom Header feature.
 */
require get_template_directory() . '/inc/custom-header.php';

/**
 * Custom template tags for this theme.
 */
require get_template_directory() . '/inc/template-tags.php';

/**
 * Functions which enhance the theme by hooking into WordPress.
 */
require get_template_directory() . '/inc/template-functions.php';

/**
 * Customizer additions.
 */
require get_template_directory() . '/inc/customizer.php';

/**
 * Load Jetpack compatibility file.
 */
if ( defined( 'JETPACK__VERSION' ) ) {
	require get_template_directory() . '/inc/jetpack.php';
}

//excerpt_length
function custom_excerpt_length( $length ) {
        return 20;
    }
    add_filter( 'excerpt_length', 'custom_excerpt_length', 999 );
	
//woocommerce_support
function mytheme_add_woocommerce_support() {
    add_theme_support( 'woocommerce' );
}
add_action( 'after_setup_theme', 'mytheme_add_woocommerce_support' );

/* Remove Woocommerce User Fields */
add_filter( 'woocommerce_checkout_fields' , 'custom_override_checkout_fields' );
add_filter( 'woocommerce_billing_fields' , 'custom_override_billing_fields' );
add_filter( 'woocommerce_shipping_fields' , 'custom_override_shipping_fields' );
 
function custom_override_checkout_fields( $fields ) {
  unset($fields['billing']['billing_country']);
  unset($fields['billing']['billing_company']);
  unset($fields['shipping']['shipping_country']);
  unset($fields['shipping']['shipping_company']);
  unset($fields['shipping']['shipping_address_1']);
  unset($fields['shipping']['shipping_address_2']);
  unset($fields['shipping']['shipping_postcode']);
  unset($fields['shipping']['shipping_city']);
  $fields['billing']['billing_email']['required'] = false;
  $fields['billing']['billing_postcode']['required'] = false;
  $fields['billing']['billing_postcode']['label'] = "کد پستی";
  
  return $fields;
}
function custom_override_billing_fields( $fields ) {
  unset($fields['billing_country']);
  unset($fields['billing_company']);
  return $fields;
}
function custom_override_shipping_fields( $fields ) {
  unset($fields['shipping_country']);
  unset($fields['shipping_company']);
  return $fields;
}
/* End - Remove Woocommerce User Fields */


//Removes Additional Information checkout page
// Removes Order Notes Title - Additional Information & Notes Field
add_filter( 'woocommerce_enable_order_notes_field', '__return_false', 9999 );

// Remove Order Notes Field
add_filter( 'woocommerce_checkout_fields' , 'remove_order_notes' );

function remove_order_notes( $fields ) {
     unset($fields['order']['order_comments']);
     return $fields;
}

//disable plugin & theme & WordPress updates
define( 'WP_AUTO_UPDATE_CORE', false );
add_filter( 'auto_update_theme', '__return_false' );
add_filter( 'auto_update_plugin', '__return_false' );
?>