<?php
/**
 * The header for our theme
 *
 * This is the template that displays all of the <head> section and everything up until <div id="content">
 *
 * @link https://developer.wordpress.org/themes/basics/template-files/#template-partials
 *
 * @package darkoob
 */

?>
<!doctype html>
<html <?php language_attributes(); ?>>
<head>
<meta charset="<?php bloginfo( 'charset' ); ?>">
<meta name="viewport" content="width=device-width, initial-scale=1">
<link rel="profile" href="https://gmpg.org/xfn/11">
<link rel="shortcut icon" type="image/x-icon" href="<?php echo get_template_directory_uri(); ?>/img/favicon.ico">
<link rel="stylesheet" type="text/css" href="<?php bloginfo('template_url'); ?>/css/bootstrap.min.css" />
<script type="text/javascript" src="<?php bloginfo('template_url'); ?>/js/bootstrap.min.js"></script>
<script type="text/javascript" src="<?php bloginfo('template_url'); ?>/js/jquery-2.1.1.min.js"></script>  
   
<?php wp_head(); ?>
</head>

<body <?php body_class(); ?>>

<?php wp_body_open(); ?>
 
<header id="masthead" class="site-header">
		
	<div class="bg-header1"> 
	    <div class="container">
		    <div class="row">
		   	    <div class="col-md-3 col-sm-3 col-xs-12 logo">
				   	<a href="<?php echo home_url(); ?>">
	          			<img src="<?php echo get_template_directory_uri(); ?>/img/logo.png" alt="Logo" class="logo-img">
	        		</a>
			    </div>
			   	<div class="col-md-6 col-sm-6 col-xs-12 tell">
			   	    <?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('tell') ) : ?><?php endif; ?>
			   	</div>
			   	<div class="col-md-3 col-sm-3 col-xs-12 social-menu">
			   	    <?php if ( !function_exists('dynamic_sidebar') || !dynamic_sidebar('social-menu') ) : ?><?php endif; ?>
			   	</div>
		   	</div>
	    </div>
    </div>

    <div class="bg-header2"> 
	    <div class="container">
		   	<div class="row">   
		   	    <div class="col-md-10 col-sm-10 col-xs-12 main-menu">
		           <?php if (!function_exists('dynamic_sidebar') || !dynamic_sidebar('main-menu')) : ?><?php endif; ?>
		        </div>
		        <div class="col-md-2 col-sm-2 col-xs-12 lan">
				  <?php if (!function_exists('dynamic_sidebar') || !dynamic_sidebar('lan')) : ?><?php endif; ?>
				</div>
			</div>
	    </div>
    </div>
   	
</header>
